#==============================================================================
#  Window_Item
#------------------------------------------------------------------------------
# ACeEBhE
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
  module Battle
    
    class Window_Item < Window_Item_Base
      include Window_Target_Module
      
      #--------------------------------------------------------------------------
      # 
      #--------------------------------------------------------------------------
      def initialize(parent,actor)
        @actor = actor
        @index = 0
        @column_max = 2
        @row_max = 3
        
        super(parent)
        
        # EBhEʒu
        self.top  = top_window.top
        self.left = top_window.left
        
        # ACewvEBhE쐬
        x = self.left
        y = self.bottom
        w = self.width
        h = Markup_New_Line.line_height * 1 + 32
        @window_help = Window_Markup_Text.new(x,y,w,h)
        @window_help.back_opacity = self.back_opacity
        
        # qEBhEɒǉ
        add_child @window_help
        @window_help.visible = false
        add_input_handler(Input::UP,:change_item)
        add_input_handler(Input::DOWN,:change_item)
        add_input_handler(Input::LEFT,:change_item)
        add_input_handler(Input::RIGHT,:change_item)
      end
      #--------------------------------------------------------------------------
      # Cxgnh
      #--------------------------------------------------------------------------
      def input_b
        if event_handling_trigger?
          @index = -1
          cancel_se
          dispose
        end
      end
      def select_item
        if item.is_a? Game_Item
          window = get_window(Window_Actor_Command)
          window.item = item
          window.item_use = true
          if Item_Facade.get_use_item(item).nil?
            top_window.dispose
            return
          end
          next_window Item_Facade.get_use_item(item)
        else
          window = Window_Item_Menu.new(self)
          set_active_window(window.class)
        end
      end
      #--------------------------------------------------------------------------
      # ACeύX
      #--------------------------------------------------------------------------
      def change_item
        if @index >= 0
          refresh_help
        end
      end
      def active_event
        if (not @window_help.nil?) and (not @window_help.disposed?)
          if self.active
            @window_help.visible = true
            refresh_help
          end
        end
      end
      #--------------------------------------------------------------------------
      # ĕ`
      #--------------------------------------------------------------------------
      def refresh
        self.clear
        refresh_actor_items
        refresh_help
        super
      end
      def refresh_help
        if (not @window_help.nil?) and (not @window_help.disposed?)
          if not self.item.nil?
            @window_help.set_text self.item.description
          else
            @window_help.set_text ""
          end
        end
      end
    end
    
  end
end
